/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.math;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;

public enum VecDirection implements StringRepresentable
{
    NEG_X("neg_x", Direction.Axis.X, Direction.AxisDirection.NEGATIVE, 2),
    POS_X("pos_x", Direction.Axis.X, Direction.AxisDirection.POSITIVE, 0),
    NEG_Y("neg_y", Direction.Axis.Y, Direction.AxisDirection.NEGATIVE, -1),
    POS_Y("pos_y", Direction.Axis.Y, Direction.AxisDirection.POSITIVE, -1),
    NEG_Z("neg_z", Direction.Axis.Z, Direction.AxisDirection.NEGATIVE, 3),
    POS_Z("pos_z", Direction.Axis.Z, Direction.AxisDirection.POSITIVE, 1);

    public static final VecDirection[] VALUES;
    private static final VecDirection[] HORIZONTALS;
    private final String name;
    private final Direction.Axis axis;
    private final Direction.AxisDirection axisDirection;
    private final int horizontalIndex;
    private final Vec3i offset;

    private VecDirection(String name, Direction.Axis axis, Direction.AxisDirection axisDirection, int horizontalIndex) {
        this.name = name;
        this.axis = axis;
        this.axisDirection = axisDirection;
        this.horizontalIndex = horizontalIndex;
        this.offset = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)axisDirection).m_122436_();
    }

    public String m_7912_() {
        return this.name;
    }

    public static VecDirection fromDirection(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> NEG_Y;
            case Direction.UP -> POS_Y;
            case Direction.NORTH -> NEG_Z;
            case Direction.SOUTH -> POS_Z;
            case Direction.WEST -> NEG_X;
            case Direction.EAST -> POS_X;
        };
    }

    public static VecDirection fromAxisAndDirection(Direction.Axis axis, Direction.AxisDirection axisDirection) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> {
                if (axisDirection == Direction.AxisDirection.POSITIVE) {
                    yield POS_X;
                }
                yield NEG_X;
            }
            case Direction.Axis.Y -> {
                if (axisDirection == Direction.AxisDirection.POSITIVE) {
                    yield POS_Y;
                }
                yield NEG_Y;
            }
            case Direction.Axis.Z -> axisDirection == Direction.AxisDirection.POSITIVE ? POS_Z : NEG_Z;
        };
    }

    public static VecDirection getNearest(Vec3i vec) {
        Direction direction = Direction.m_122372_((float)vec.m_123341_(), (float)vec.m_123342_(), (float)vec.m_123343_());
        return VecDirection.fromAxisAndDirection(direction.m_122434_(), direction.m_122421_());
    }

    public VecDirection getOpposite() {
        return VALUES[this.ordinal() ^ 1];
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public Direction.AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public Vec3i getOffset() {
        return this.offset;
    }

    public boolean isPositive() {
        return this.axisDirection == Direction.AxisDirection.POSITIVE;
    }

    public VecDirection applyY(Rotation rotation) {
        return HORIZONTALS[(this.getHorizontalIndex() + rotation.ordinal()) % HORIZONTALS.length];
    }

    static {
        VALUES = VecDirection.values();
        HORIZONTALS = new VecDirection[]{POS_X, POS_Z, NEG_X, NEG_Z};
    }
}

